/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.util.collection;

import icyllis.annotations.NotNull;
import icyllis.flexmark.util.collection.IndexedItemSetMapBase;
import java.util.BitSet;
import java.util.function.Function;

public class IndexedItemBitSetMap<K, M>
extends IndexedItemSetMapBase<K, BitSet, M> {
    @NotNull
    private final Function<M, K> computable;

    public IndexedItemBitSetMap(@NotNull Function<M, K> computable) {
        this(computable, 0);
    }

    public IndexedItemBitSetMap(@NotNull Function<M, K> computable, int capacity) {
        super(capacity);
        this.computable = computable;
    }

    @NotNull
    public Function<M, K> getComputable() {
        return this.computable;
    }

    @Override
    @NotNull
    public K mapKey(@NotNull M key) {
        return this.computable.apply(key);
    }

    @Override
    @NotNull
    public BitSet newSet() {
        return new BitSet();
    }

    @Override
    public boolean addSetItem(@NotNull BitSet set, int item) {
        boolean old = set.get(item);
        set.set(item);
        return old;
    }

    @Override
    public boolean removeSetItem(@NotNull BitSet set, int item) {
        boolean old = set.get(item);
        set.clear(item);
        return old;
    }

    @Override
    public boolean containsSetItem(@NotNull BitSet set, int item) {
        return set.get(item);
    }
}

